<?php
declare(ticks=1);
mb_internal_encoding('UTF-8');
error_reporting(E_ALL | E_NOTICE);
/**
 * send Http Request
 *
 * @param string $url 目标地址
 * @param array $config 配置
 * @param string|int $timeOut 超时时间
 * @param array $httpHeaders 头部
 * @return array
 */
function request(string $url, array $config = [], $timeOut = 60, array $httpHeaders = []): array
{
    $httpConfig = array_merge([
        'type'             => 'POST',
        'body'             => [],
        'headerType'       => 'application/x-www-form-urlencoded; charset=UTF-8',
        'formatter'        => [
            'type'       => 'http_build_query',
            'bindParams' => [],
        ],
        'resultReturnType' => 'json',
        'cookie'           => [],
        'ua'               => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.193 Safari/537.36',
        'version'          => CURL_HTTP_VERSION_1_1,
    ], $config);
    $filter = is_callable($func = $httpConfig['formatter']['type']) ? $func : 'http_build_query';
    array_unshift($httpConfig['formatter']['bindParams'], $httpConfig['body']);
    $params = call_user_func_array($filter, $httpConfig['formatter']['bindParams']);
    $headers = array_merge([
        'Content-Type'    => $httpConfig['headerType'],
        'Accept-Language' => 'zh-CN,zh-TW;q=0.9,zh;q=0.8,en-US;q=0.7,en;q=0.6',
    ], $httpHeaders);
    $headers = array_map(function ($value, $header) {
        return $header . ': ' . $value;
    }, $headers, array_keys($headers));

    $requestMethod = strtoupper($httpConfig['type']);
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($curl, CURLOPT_TIMEOUT, $timeOut);
    if ($requestMethod === 'POST') {
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $params);
    } else {
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $requestMethod);
    }
    if (!empty($httpConfig['cookie'])) {
        $cookieString = is_array($httpConfig['cookie']) ? http_build_query($httpConfig['cookie'], '=', ';') : $httpConfig['cookie'];
        curl_setopt($curl, CURLOPT_COOKIE, $cookieString);
    }
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);                             // 请求头部
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);                             // 301、302 重定向
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);                             // 以文件流的形式返回
    curl_setopt($curl, CURLOPT_USERAGENT, $httpConfig['ua']);                     // 请求UA标识
    curl_setopt($curl, CURLOPT_HTTP_VERSION, $httpConfig['version']);             // HTTP 版本
    $response = curl_exec($curl);
    if (false === $response) {
        $result = ['errCode' => -999, 'errMsg' => curl_error($curl)];
    } else if (($httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE)) && $httpCode != 200) {
        $result = ['errCode' => -3, 'errMsg' => "($httpCode)->" . curl_error($curl), 'rawBody' => $response, 'httpCode' => $httpCode];
    } else {
        $result = ['errCode' => 0, 'errMsg' => 'Ok', 'httpCode' => $httpCode, 'resultData' => $httpConfig['resultReturnType'] === 'json' ? json_decode($response, true) : $response, 'rawBody' => $response];
    }
    curl_close($curl);
    return $result;
}

/**
 * @param array $data 参数
 * @param array $options 配置项
 * @return string
 */
function sign(array $data, array $options = []): string
{
    $defaultOption = [
        'case'        => CASE_UPPER,
        'sort'        => true,
        'key'         => '',
        'filter'      => true,
        'ignore_keys' => [],
    ];
    $options = array_merge($defaultOption, $options);
    $options['sort'] && ksort($data);
    $options['filter'] && $data = array_filter($data);
    $data = array_diff_key($data, array_flip($options['ignore_keys']));
    $linkStr = urldecode(http_build_query($data));
    $sign = md5($linkStr . $options['key']);
    return $options['case'] & CASE_UPPER ? strtoupper($sign) : strtolower($sign);
}
// API网关地址
define('API_GATEWAY', 'https://open-api.qqzwb.com');
// App ID
define('API_ID' , 'ID填写在这里');
// App Key
define('APP_KEY' , '密钥填写在这里');
// 请求实例：域名/demo.php?uin={必填项,QQ号码}&page={可填,页码}
$uin = $_REQUEST['uin'] ?? '';
$page = intval($_REQUEST['page'] ?? 1);
$params = [
    'app_id' =>  '10000',
    'sign_type' => 'md5',
];
$params = $params + [
    'uin'   =>  $uin,
    'page'  =>  $page,
];
$params['sign'] = sign($params , [
    'key'   =>  APP_KEY,
    'ignore_keys' => ['signature', 'sign', 'key' , 'sign_type'],
]);
$result = request(API_GATEWAY . '/api/api_helper/get_ss_v2/1' , [
    'body'  =>  $params
]);

print_r($result);